---
title: Console · Cloudflare Workers docs
description: Supported methods of the `console` API in Cloudflare Workers
lastUpdated: 2025-07-25T16:42:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/runtime-apis/console/
  md: https://developers.cloudflare.com/workers/runtime-apis/console/index.md
---

The `console` object provides a set of methods to help you emit logs, warnings, and debug code.

All standard [methods of the `console` API](https://developer.mozilla.org/en-US/docs/Web/API/console) are present on the `console` object in Workers.

However, some methods are no ops — they can be called, and do not emit an error, but do not do anything. This ensures compatibility with libraries which may use these APIs.

The table below enumerates each method, and the extent to which it is supported in Workers.

All methods noted as "✅ supported" have the following behavior:

* They will be written to the console in local dev (`npx wrangler@latest dev`)
* They will appear in live logs, when tailing logs in the dashboard or running [`wrangler tail`](https://developers.cloudflare.com/workers/observability/log-from-workers/#use-wrangler-tail)
* They will create entries in the `logs` field of [Tail Worker](https://developers.cloudflare.com/workers/observability/tail-workers/) events and [Workers Trace Events](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/workers_trace_events/), which can be pushed to a destination of your choice via [Logpush](https://developers.cloudflare.com/workers/observability/logpush/).

All methods noted as "🟡 partial support" have the following behavior:

* In both production and local development the method can be safely called, but will do nothing (no op)
* In the [Workers Playground](https://workers.cloudflare.com/playground), Quick Editor in the Workers dashboard, and remote preview mode (`wrangler dev --remote`) calling the method will behave as expected, print to the console, etc.

Refer to [Log from Workers](https://developers.cloudflare.com/workers/observability/log-from-workers/) for more on debugging and adding logs to Workers.

| Method | Behavior |
| - | - |
| [`console.debug()`](https://developer.mozilla.org/en-US/docs/Web/API/console/debug_static) | ✅ supported |
| [`console.error()`](https://developer.mozilla.org/en-US/docs/Web/API/console/error_static) | ✅ supported |
| [`console.info()`](https://developer.mozilla.org/en-US/docs/Web/API/console/info_static) | ✅ supported |
| [`console.log()`](https://developer.mozilla.org/en-US/docs/Web/API/console/log_static) | ✅ supported |
| [`console.warn()`](https://developer.mozilla.org/en-US/docs/Web/API/console/warn_static) | ✅ supported |
| [`console.clear()`](https://developer.mozilla.org/en-US/docs/Web/API/console/clear_static) | 🟡 partial support |
| [`console.count()`](https://developer.mozilla.org/en-US/docs/Web/API/console/count_static) | 🟡 partial support |
| [`console.group()`](https://developer.mozilla.org/en-US/docs/Web/API/console/group_static) | 🟡 partial support |
| [`console.table()`](https://developer.mozilla.org/en-US/docs/Web/API/console/table_static) | 🟡 partial support |
| [`console.trace()`](https://developer.mozilla.org/en-US/docs/Web/API/console/trace_static) | 🟡 partial support |
| [`console.assert()`](https://developer.mozilla.org/en-US/docs/Web/API/console/assert_static) | ⚪ no op |
| [`console.countReset()`](https://developer.mozilla.org/en-US/docs/Web/API/console/countreset_static) | ⚪ no op |
| [`console.dir()`](https://developer.mozilla.org/en-US/docs/Web/API/console/dir_static) | ⚪ no op |
| [`console.dirxml()`](https://developer.mozilla.org/en-US/docs/Web/API/console/dirxml_static) | ⚪ no op |
| [`console.groupCollapsed()`](https://developer.mozilla.org/en-US/docs/Web/API/console/groupcollapsed_static) | ⚪ no op |
| [`console.groupEnd`](https://developer.mozilla.org/en-US/docs/Web/API/console/groupend_static) | ⚪ no op |
| [`console.profile()`](https://developer.mozilla.org/en-US/docs/Web/API/console/profile_static) | ⚪ no op |
| [`console.profileEnd()`](https://developer.mozilla.org/en-US/docs/Web/API/console/profileend_static) | ⚪ no op |
| [`console.time()`](https://developer.mozilla.org/en-US/docs/Web/API/console/time_static) | ⚪ no op |
| [`console.timeEnd()`](https://developer.mozilla.org/en-US/docs/Web/API/console/timeend_static) | ⚪ no op |
| [`console.timeLog()`](https://developer.mozilla.org/en-US/docs/Web/API/console/timelog_static) | ⚪ no op |
| [`console.timeStamp()`](https://developer.mozilla.org/en-US/docs/Web/API/console/timestamp_static) | ⚪ no op |
| [`console.createTask()`](https://developer.chrome.com/blog/devtools-modern-web-debugging/#linked-stack-traces) | 🔴 Will throw an exception in production, but works in local dev, Quick Editor, and remote preview |
